﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class Tax
    {

        public Tax()
        {

        }

        public Tax(IDataReader myDataRecord)
        {
            TaxID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TaxID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("TaxID"));
            TaxName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TaxName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("TaxName"));
            TaxDescription = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TaxDescription")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("TaxDescription"));
            TaxType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TaxType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("TaxType"));
            TaxValue = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TaxValue")) ? 0.00M: myDataRecord.GetDecimal(myDataRecord.GetOrdinal("TaxValue"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue: myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            CreatedBy = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            ModifiedBy = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ModifiedBy"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            ApplyTaxAsDefault = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ApplyTaxAsDefault")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("ApplyTaxAsDefault"));
            //IsCompoundedTax = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsCompoundedTax")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsCompoundedTax"));
            //SequenceNo = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("SequenceNo")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("SequenceNo"));
        }

        [DataObjectField(true, false, false)]
        public Guid TaxID { get; set; }

        public string TaxName { get; set; }

        public string TaxDescription { get; set; }

        public string TaxType { get; set; }

        public decimal TaxValue { get; set; }

        public DateTime CreatedDate { get; set; }

        public DateTime ModifiedDate { get; set; }

        public Guid CreatedBy { get; set; }

        public Guid ModifiedBy { get; set; }

        public bool IsActive { get; set; }

        public bool ApplyTaxAsDefault { get; set; }

        //public bool IsCompoundedTax { get; set; }

        //public int SequenceNo { get; set; }

    }
}
